(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7703,        233]*)
(*NotebookOutlinePosition[      8542,        260]*)
(*  CellTagsIndexPosition[      8498,        256]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\( (*\ 
      Example\ 7.3  .1\ \nintx = 
        integral\ of\ g[s]\ wrt\ s\ from\ 0\ to\ 1\ *) \n
    g[s_] := x*Log[x + s]; \nintx = x*\((Log[x + 1] - 1)\); 
    \n (*\ By\ repeated\ midpoint\ rule\ n = 2\ *) \n
    int = 0.5*\((g[0.25] + g[0.75])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)\)], "Input"],

Cell[BoxData[
    \(0.00179294422312647157`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ repeated\ midpoint\ rule\ n = 4\ *) \nClear[int]; \n
    int = 0.25*\((g[0.25] + g[0.5] + g[0.75] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)\)], "Input"],

Cell[BoxData[
    \(0.00418823490127090281`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ repeated\ midpoint\ rule\ n = 8\ *) \nClear[int]; \n
    int = 0.125*
        \((g[1/8] + g[1/4] + g[3/8] + g[1/2] + g[1/2] + g[5/8] + g[3/4] + 
            g[7/8] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)\)], "Input"],

Cell[BoxData[
    \(0.00178607215566276344`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ repeated\ midpoint\ rule\ n = 16\ *) \nClear[int]; \n
    int = \((g[1/16] + g[1/8] + g[3/16] + g[1/4] + g[5/16] + g[3/8] + 
            g[7/16] + g[1/2] + g[9/16] + g[5/8] + g[11/16] + g[3/4] + 
            g[13/16] + g[7/8] + g[15/16] + g[1])\)/16; \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)\)], "Input"],

Cell[BoxData[
    \(0.00167084555499006341`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*By\ repeated\ trapezoidal\ rule\ n = \(5 : \)*) \nClear[int]; \n
    int = \((1/10)\)*
        \((g[0] + 2*g[0.2] + 2*g[0.4] + 2*g[0.6] + 2*g[0.8] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)\)], "Input"],

Cell[BoxData[
    \(0.00100924960502437111`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ repeated\ trapezoidal\ rule\ n = 10\ *) int = 
      \((1/20)\)*
        \((\ g[0] + 2*g[0.1] + 2*g[0.2] + 2*g[0.3] + 2*g[0.4] + 2*g[0.5] + 
            2*g[0.6] + 2*g[0.7] + 2*g[0.8] + 2*g[0.9] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.0000429798931524741334`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 20\ *) \n
    int = \((1/40)\)*
        \((\ g[0] + 2*g[0.05] + 2*g[0.1] + 2*g[0.15] + 2*g[0.2] + 2*g[0.25] + 
            2*g[0.3] + 2*g[0.35] + 2*g[0.4] + 2*g[0.45] + 2*g[0.5] + 
            2*g[0.55] + 2*g[0.6] + 2*g[0.65] + 2*g[0.7] + 2*g[0.75] + 
            2*g[0.8] + 2*g[0.85] + 2*g[0.9] + 2*g[0.95] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.000302427631819349507`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 40\ *) \n
    int = \((1/80)\)*
        \((\ g[0] + 2*g[0.025] + 2*g[0.05] + 2*g[0.075] + \n\t\t\t\ \ \ \ \ \ 
            2*g[0.1] + 2*g[0.125] + 2*g[0.15] + 2*g[0.175] + 2*g[0.2] + 
            2*g[0.225] + 2*g[0.25] + 2*g[0.275] + 2*g[0.3] + 2*g[0.325] + 
            2*g[0.35] + 2*g[0.375] + 2*g[0.4] + 2*g[0.425] + 2*g[0.45] + 
            2*g[0.475] + 2*g[0.5] + 2*g[0.525] + 2*g[0.55] + 2*g[0.575] + 
            2*g[0.6] + 2*g[0.625] + 2*g[0.65] + 2*g[0.675] + 2*g[0.7] + 
            2*g[0.725] + 2*g[0.75] + 2*g[0.775] + 2*g[0.8] + 2*g[0.825] + 
            2*g[0.85] + 2*g[0.875] + 2*g[0.9] + 2*g[0.925] + 2*g[0.95] + 
            2*g[0.975] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.000415500164894626689`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 5\ *) \n
    int = \((1/15)\)*\((\ g[0] + 4*g[0.25] + 2*g[0.5] + 4*g[0.75] + g[1])\); 
    \nerror = Abs[intx\  - \ int] /. \ x -> 0.1\)], "Input"],

Cell[BoxData[
    \(0.0366137128415174206`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 7\ *) \n
    int = \((1/21)\)*
        \((\ g[0] + 4*g[1/6] + 2*g[1/3] + 4*g[1/2] + \n\t\t\t\t2*g[2/3] + 
            4*g[5/6] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.00141316706270499388`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 9*) \n
    int = \((1/27)\)*
        \((\ g[0] + 4*g[1/8] + 2*g[1/4] + 4*g[3/8] + \n\t\t\t\t2*g[1/2] + 
            4*g[5/8] + 2*g[3/4] + 4*g[7/8] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.00126416654842904407`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 11*) \n
    int = \((1/33)\)*
        \((\ g[0] + 4*g[1/10] + 2*g[1/5] + 4*g[3/10] + \n\t\t\t\t2*g[2/5] + 
            4*g[1/2] + 2*g[3/5] + 4*g[7/10] + 2*g[4/5] + 4*g[9/10] + g[1])\); 
    \nerror = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.00115378152722877924`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 17*) \n
    int = \((1/51)\)*
        \((\ g[0] + 4*g[1/16] + 2*g[2/16] + 4*g[3/16] + \n\t\t\t\t2*g[4/16] + 
            4*g[5/16] + 2*g[6/16] + 4*g[7/16] + 2*g[8/16] + 4*g[9/16] + 
            2*g[10/16] + 4*g[11/16] + 2*g[12/16] + 4*g[13/16] + 2*g[14/16] + 
            4*g[15/16] + g[1])\); \n
    error = Abs[intx\  - \ int] /. \ x -> 0.01\)], "Input"],

Cell[BoxData[
    \(0.000949810879793665563`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Other\ values\ of\ n\ can\ be\ similarly\ worked\ out, \n\t
      and\ the\ results\ of\ Table\ 7.3  .1, \ obtained\ by\ Baker, \ 
      can\ be\ matched\ for\ a\ particular\ value\ of\ x\ chosen\ in\ the\ 
        interval\ \((0, 1)\)\ *) \)], "Input"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 338, 7, 123, "Input"],
Cell[2072, 60, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2166, 66, 204, 3, 75, "Input"],
Cell[2373, 71, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2467, 77, 270, 5, 91, "Input"],
Cell[2740, 84, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2834, 90, 346, 5, 123, "Input"],
Cell[3183, 97, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3277, 103, 247, 4, 91, "Input"],
Cell[3527, 109, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3621, 115, 316, 6, 107, "Input"],
Cell[3940, 123, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4036, 129, 443, 7, 139, "Input"],
Cell[4482, 138, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4577, 144, 788, 12, 219, "Input"],
Cell[5368, 158, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5463, 164, 212, 3, 91, "Input"],
Cell[5678, 169, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5771, 175, 265, 5, 91, "Input"],
Cell[6039, 182, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6133, 188, 285, 5, 91, "Input"],
Cell[6421, 195, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6515, 201, 312, 5, 107, "Input"],
Cell[6830, 208, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6924, 214, 421, 7, 139, "Input"],
Cell[7348, 223, 58, 1, 26, "Output"]
}, Open  ]],
Cell[7421, 227, 278, 4, 75, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

